/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: $:

  Description:
    Demo implementation of the CIFX Toolkit "Low-Level" Hardware Access Functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2018-08-08  review

**************************************************************************************/

#include "cifXHWFunctions.h"
#include "OS_Dependent.h"
#include "OS_Includes.h"

/* Error & Type Def. */
#include "CIFXErrors.h"

/* general device functions */
#include "DEV_InterfaceUser.h"
#include "DEV_FileUser.h"

#include <tchar.h>

/* ============================================================================= */
/* Global infomation and definitions                                             */
/* ============================================================================= */
typedef long(APIENTRY *PFN_DRIVER_MEMPTRY)(HANDLE  hDriver, unsigned long ulBoard, unsigned long ulCmd,void* pvMemoryInfo);

static uint32_t           s_ulChannelOffset     = 0;
static uint32_t           s_ulChannelSize       = 0;

static MEMORY_INFORMATION s_tMemoryInfo         = {0};
static PFN_DRIVER_MEMPTRY s_pfnDriverGetMemPtr  = NULL;
static HMODULE            s_hCifxDll            = NULL;

#define                   BOARD_NO              0     /* Just use the first Board we found */

/*****************************************************************************/
/*! Gets a pointer to the first board from the cifX driver and stores it
*   in global variables.
*   \return true on success                                                  */
/*****************************************************************************/
BOOL cifXGetMemptr( uint8_t** ppbDPM, uint32_t* pulDPMSize, unsigned long ulBoardIdx)
{
  BOOL fRet = FALSE;

  /* We need to dynamically load the dll and function pointer, to prevent duplicate
     functions (toolkit and driver functions) at link time */
  s_hCifxDll = LoadLibrary(_T("cifX32dll.dll"));

  if(NULL != s_hCifxDll)
  {
    /* DLL could be dynamically loaded */
    s_pfnDriverGetMemPtr = (PFN_DRIVER_MEMPTRY)GetProcAddress(s_hCifxDll, (LPCSTR)_T("xDriverMemoryPointer"));

    if(NULL == s_pfnDriverGetMemPtr)
    {
      /* xDriverMemoryPointer function not found in cifx32dll.dll */
      CloseHandle(s_hCifxDll);
      s_hCifxDll = NULL;
    } else
    {
      long lRet;

      /* xDriverMemoryPointer function successfully found */
      s_tMemoryInfo.pulMemorySize         = pulDPMSize;
      s_tMemoryInfo.ppvMemoryPtr          = (void**)ppbDPM;
      s_tMemoryInfo.ulChannel             = CIFX_NO_CHANNEL;    /* Map the whole DPM area of the board */
      s_tMemoryInfo.pulChannelStartOffset = &s_ulChannelOffset;
      s_tMemoryInfo.pulChannelSize        = &s_ulChannelSize;

      lRet = s_pfnDriverGetMemPtr(NULL, ulBoardIdx, CIFX_MEM_PTR_OPEN, &s_tMemoryInfo);

      if(CIFX_NO_ERROR == lRet)
      {
        /* Pointer successfully returned */
        fRet = TRUE;
      }
    }
  }
  return fRet;
}

/*****************************************************************************/
/*! Return a previously acquired DPM pointer                                 */
/*  This is an OS specific implementation. In case of a Win32 test, the      */
/*  pointer to the DPM must be taken from the CIFX Windows driver!           */
/*****************************************************************************/
void cifXReleaseMemptr(void)
{
  if(NULL != s_pfnDriverGetMemPtr)
  {
    int32_t lRet = s_pfnDriverGetMemPtr(NULL, BOARD_NO, CIFX_MEM_PTR_CLOSE, &s_tMemoryInfo);
    lRet = lRet;
  }

  FreeLibrary(s_hCifxDll);
  s_pfnDriverGetMemPtr = NULL;
}


/*****************************************************************************/
/*! Retrieves a pointer to the netX DPM (Dual Ported Memomry)
*   This function needs to be adapted for own needs
*   \param ppbDPM       Pointer to a char pointer which will be loaded to the DPM address
*   \param pulDPMSize   Pointer to an uint32_t value receiving the DPM size
*
*   \return 1 on success                                                  */
/*****************************************************************************/
int cifXTkHWFunctions_GetDPMPointer( uint8_t** ppbDPM, uint32_t* pulDPMSize)
{
  int fRet = 0;

  /* !!! TODO: replace the the function call -cifXGetMemptr()- with own code !!! */
  /* ...                                                                         */
  /* !!! place code to configure or map the DPM pointer here !!!                 */  

  fRet = cifXGetMemptr(  ppbDPM, pulDPMSize, BOARD_NO) ? 1 : 0;


  return fRet;
}

/*****************************************************************************/
/*! Release the DPM pointer retrieved by calling cifXTkHWFunctions_GetDPMPointer()
*   This function needs to be adapted for own needs
*   \param pbDPM  DPM pointer, retrieved by cifXTkHWFunctions_GetDPMPointer()
*   \return true on success                                                  */
/*****************************************************************************/
void cifXTkHWFunctions_FreeDPMPointer( uint8_t* pbDPM)
{
  /* !!! TODO: replace the the function call -cifXReleaseMemptr()- with own code !!! */
  /* ...                                                                             */
  /* !!! place code to unconfigure or unmap the DPM pointer here !!!                 */  

  if( NULL != pbDPM)
    cifXReleaseMemptr();
}

int32_t cifXHWSample(void);

/*****************************************************************************/
/*! Main routine
*
* \return 0 on success                                                       */
/*****************************************************************************/
int main(void)
{
	return cifXHWSample();
}

